# Diagram to EMF
# Copyright 2008 by Brian C. Christensen

# 080603 - start first draft
# 080611 - fix draw order for objectified fact types

import wx

debug = 1

def Draw(report, dc):
##    all_shapes = report.GetList('GraphicObject')  # graphic objects that point to this report
    # must draw shapes in the right order or objectified facttype may be reversed
    all_shapes = [ self.Report.win.dcid_to_shape_xref.get(dcid) for dcid in self.Report.win.objids ]
    if any([ shape.IsSelected for shape in all_shapes ]):
        for shape in all_shapes:
            if shape.IsSelected:
                shape.ClearSelected()
                shape.Draw(dc)
                shape.SetSelected()  # this changes keyboard target ?problem?
    else:
        for shape in all_shapes:
            shape.Draw(dc)
    return True

def Do(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        hint('Not for use in main report')
        return  # do nothing

    db = Data.DBObject  # will get objects from this database
    report = db.GetObject('Report',rid)

    class MetaFileDC(wx.MetaFileDC):
        def ClearId(self, *parms):
            pass
        def SetId(self, *parms):
            pass
        def SetIdBounds(self, *parms):
            pass

    emf_dc = MetaFileDC();
    if emf_dc.Ok():
        Draw(report, emf_dc)
        emf = emf_dc.Close()
    if (emf):
        success = emf.SetClipboard(int(emf_dc.MaxX() + 10), int(emf_dc.MaxY() + 10));
        del emf;  # required in C; needed here?

Do(self)

